﻿function hide(el) { el.classList.add("hidden"); }
function show(el) { el.classList.remove("hidden"); }

function fadeIn(el, suffix = "-bck", delay = 1) {
    el.classList.add("fade-in" + suffix);
    if (delay)
        el.classList.add("delayed-" + delay);
    show(el);
    setTimeout(() => {
        el.classList.remove("fade-in" + suffix);
        if (delay)
            el.classList.remove("delayed-" + delay);
    }, 400 + delay * 100);
}

function fadeOut(el, suffix = "-bck") {
    el.classList.add("fade-out" + suffix);
    setTimeout(() => {
        el.classList.remove("fade-out" + suffix);
        hide(el);
    }, 400);
}

module.exports = { hide, show, fadeIn, fadeOut };